# GDS Launcher – Research Prototype

## Background and Motivation

This work is a **personal research prototype** inspired by the following KLayout forum discussion:

https://www.klayout.de/forum/discussion/2834/

The original forum post proposed this approach:

> *"Our approach is to develop a KLayout plugin that will:"*
>
> - Authenticate and create a session with the application via REST APIs  
> - Download the GDSII file locally  
> - Programmatically load the file into KLayout  

This prototype intentionally **does not follow the KLayout plugin approach** and instead explores an alternative architecture.

---

## Authorship and Tooling Note (Important)

Almost **all of the code in this repository was generated by ChatGPT (GPT‑5.2)**,
through an interactive design and review process.

Human contributions mainly consisted of:

- Architectural decisions and constraints
- UI behavior requirements and corrections
- Iterative testing and validation
- Final review and integration

This project is therefore also an **experiment in AI‑assisted software design**, not just a KLayout integration study.

---

## Design Philosophy

### 1. No KLayout Plugin

Although the initial discussion focuses on *developing a KLayout plugin*, this prototype deliberately explores a **different architectural direction**.

KLayout is treated as an **external application** launched with explicit command-line arguments.
No Ruby or Python plugin is developed inside KLayout itself.

This avoids:

- Dependency on KLayout internal APIs
- Version-specific plugin maintenance
- Increased debugging complexity

---

### 2. External GUI Using PySide6

All user interaction is implemented in a **standalone GUI** built with **PySide6**.

The GUI is responsible for:

- Parsing the XML input file
- Collecting user credentials
- Communicating with a REST (Representational State Transfer) backend
- Downloading GDS and LYP files

KLayout itself is **not responsible for authentication, networking, or UI**.

---

### 3. Simple and Explicit KLayout Invocation

KLayout is launched explicitly as:

```bash
klayout -l <layout.lyp> <layout.gds>
```

This ensures:

- Deterministic layer properties
- Clear data flow
- No implicit or hidden plugin behavior

---

## Overview

1. An XML file containing a `<GdsRefId>` is provided.
2. The launcher authenticates against a REST (Representational State Transfer) backend.
3. The backend resolves the reference ID.
4. Matching **GDS** and **LYP** files are downloaded.
5. KLayout is launched with the downloaded files.

---

## Directory Layout

```
Forum2834/
  ReadMe.md
  Launcher.py
  mock_backend.py
  testdata/
    sample.gds
    sample.lyp
    cobra3b.gds
    cobra3b.lyp
  input_01.xml
  input_02.xml
```

---

## XML Input Format

Example:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<Root>
    <GdsRefId>TEST-GDS-001</GdsRefId>
</Root>
```

---

## Test Data Notes

| GdsRefId | GDS file | LYP file | Notes |
|---------|----------|----------|-------|
| TEST-GDS-001 | sample.gds | sample.lyp | Simple synthetic test layout |
| TEST-GDS-002 | cobra3b.gds | cobra3b.lyp | Layout borrowed from **Forum #2827** (original author: Kazzz-S) |

The `cobra3b` layout was reused from an earlier forum discussion to provide a more realistic, non-trivial test case.

---

## Mock Backend Server

### Start

When running **on the same machine as the client**, the default loopback address can be used:

```bash
./mock_backend.py --host 127.0.0.1 --port 8000
```

When running the server on a **different machine** and accessing it over the network,
the server must be bound to all interfaces:

```bash
./mock_backend.py --host 0.0.0.0 --port 8000
```

### Authentication

Default credentials can be set either as separate commands:

```bash
export MOCK_USER=simran
export MOCK_PASS=simran
```

or as a single one-line command:

```bash
MOCK_USER=simran MOCK_PASS=simran ./mock_backend.py --host 0.0.0.0 --port 8000
```

---

## Important Note on Security Software

If the server machine is running **third-party security or endpoint protection software**
(e.g. firewall or network filtering provided by security tools),
LAN-based HTTP communication may be silently blocked even when the OS-level firewall is disabled.

For the purpose of this prototype and testing:

- Such security software should be **temporarily disabled** on the server machine.
- Otherwise, the client may observe errors such as *"Empty reply from server"* despite correct server behavior.

---

## Launcher Client

### Requirements

- Python 3.10+
- PySide6
- KLayout available as `klayout` in PATH

### Run

```bash
./Launcher.py input_01.xml
```

or

```bash
python Launcher.py input_02.xml
```

---

## UI Behavior

- Enter moves focus between input fields (URL → Username → Password → Login button).
- Enter on the Login button or mouse click triggers login.
- Enter in input fields never triggers login.
- Copy button is mouse-only.

---

## Notes

- This prototype is intended for architectural exploration and discussion.
- It demonstrates one possible alternative to KLayout plugin-based integration.
- The mock backend is for testing only.

---

End of document.
